package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.DataTransfer;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.Map;

/**
 * 2 * @Author: zgl
 * 3 * @Date: 2020/10/23 11:27
 * 4
 */
@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/data-transfer")
public interface DataTransferClient {
    @PostMapping("/save/data")
    public DataTransfer saveData(@RequestBody DataTransfer dataTransfer);

    @GetMapping("/find/id")
    public DataTransfer findById(@RequestParam(name = "id") String id);

    @GetMapping("/find/trans/processid")
    public DataTransfer findByProcessInsId(@RequestParam(name = "processid") String processid);

    @PostMapping("/del/id")
    public Map delById(@RequestParam(name = "id") String id);

    @GetMapping("/query/title/page")
    public Page<DataTransfer> queryDataPages(@RequestParam(name = "title", required = false) String title, Pageable pageable);

    @PostMapping("/apply/trans/data")
    public Map applyTransData(@RequestBody DataTransfer dataTransfer, @RequestParam(name = "auditor", required = false) String auditor);

    @PostMapping("/approval/trans/data")
    public Map approvalTransData(@RequestBody DataTransfer dataTransfer, @RequestParam(name = "taskId") String taskId, @RequestParam(name = "appState") String appState);
}
