package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.DataRepair;
import cn.gtmap.gtc.resource.domain.resource.metadata.DataTransfer;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author gt-weiran
 * @date 2021-03-25-16:30
 * version
 * illustration
 */
@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/data-repair")
public interface DataRepairClient {
    @PostMapping("/save/data")
    DataRepair saveData(@RequestBody DataRepair dataRepair);

    @GetMapping("/find/id")
    DataRepair findById(@RequestParam(name = "id") String id);

    @GetMapping("/find/trans/processid")
    DataRepair findByProcessInsId(@RequestParam(name = "processid") String processid);

    @PostMapping("/del/id")
    Map delById(@RequestParam(name = "id") String id);

    @PostMapping("/apply/trans/data")
    Map applyRepairData(@RequestBody DataRepair dataRepair, @RequestParam(name = "auditor", required = false) String auditor);

    @PostMapping("/approval/trans/data")
    Map approvalRepairData(@RequestBody DataRepair dataRepair, @RequestParam(name = "taskId") String taskId, @RequestParam(name = "appState") String appState);

}
