package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.DataApply;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 2 * @Author: zgl
 * 3 * @Date: 2020/10/24 16:54
 * 4
 */
@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/data-apply")
public interface DataApplyClient {

    @PostMapping("/save/data")
    public DataApply saveData(@RequestBody DataApply DataApply);

    @GetMapping("/find/id")
    public DataApply findById(@RequestParam(name = "id") String id);

    @GetMapping("/find/apply/processid")
    public DataApply findByProcessInsId(@RequestParam(name = "processid") String processid);

    @PostMapping("/del/id")
    public Map delById(@RequestParam(name = "id") String id);

    @GetMapping("/query/title/page")
    public Page<DataApply> queryDataPages(@RequestParam(name = "title", required = false) String title, Pageable pageable);

    @PostMapping("/apply/data")
    public Map applyData(@RequestBody DataApply DataApply, @RequestParam(name = "auditor", required = false) String auditor);

    @PostMapping("/approval/apply/data")
    public Map approvalData(@RequestBody DataApply DataApply, @RequestParam(name = "taskId") String taskId, @RequestParam(name = "appState") String appState);
}
