package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.CjghglZjb;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/cjghgl")
public interface CjghglClient {

    /**
     * 保存
     *
     * @param cjghglZjb
     * @return
     */
    @PostMapping("/save")
    Map saveCjghglZjb(@RequestBody CjghglZjb cjghglZjb);

    /**
     * 查询
     *
     * @param id
     * @return
     */
    @GetMapping("/queryById")
    CjghglZjb queryById(@RequestParam(name = "id") String id);

    /**
     * 根据id获取图形
     *
     * @param id
     * @return
     */
    @GetMapping("/getGeometry")
    Map getGeoemtry(@RequestParam(name = "id") String id);

    /**
     * 根据id更新图形属性
     *
     * @param guId
     * @return
     */
    @GetMapping("/update")
    Map update(@RequestParam(name="guId") String guId);
}
