package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.config.response.ResponseData;
import cn.gtmap.gtc.resource.config.response.SuccessResponseData;
import cn.gtmap.gtc.resource.domain.resource.metadata.CatalogResTypeRef;
import com.alibaba.fastjson.JSONArray;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/catalog/res/type")
public interface CatalogResTypeRefClient {

    @PostMapping("/save/res/type")
    public Map save(@RequestBody Map params);

    @GetMapping("/find/res/{resourceTypeId}")
    public List<CatalogResTypeRef> findAllByResourceId(@PathVariable(name = "resourceTypeId") String resourceTypeId);

    @GetMapping("/getResourceTypeCatalogs")
    public ResponseData findAllByResourceId();

    /**
     * 保存资源类型详情数据
     * @param data = JSON.stringify(data)
     * var data = {
     *             'resTypeId': 资源类型id,
     *             'resName': 名称,
     *             'resUrl': url,
     *             'resIcon': 封面图,
     *             'resIsPublic': 是否公开,
     *             'resDescription': 描述
     *         };
     * @return
     */
    @RequestMapping("/updateResourceTypeAppend")
    public ResponseData updateResourceTypeAppend(@RequestParam("data") String data);

    /**
     * 保存资源扩展属性详情数据
     * @param data = JSON.stringify(data)
     * var data = {
     *     'resTypeId': '',  //左边选中资源类型id
     *     'resExtendId': '', // 当前选中编辑的属性id
     *     'resExtendType': '', // 类型，String："select"或者"formSelect"
     *     'resExtendIfLimit': '' // 是否必填，String: "true" 或者 "false"
     * }
     * @return
     */
    @RequestMapping("/updateResourceAttributeAppend")
    public ResponseData updateResourceAttributeAppend(@RequestParam(name = "data") String data);

    @RequestMapping("/deleteResourceType")
    public ResponseData deleteResourceType(@RequestParam(name = "typeId") String typeId);

    @RequestMapping("/findDefaultCatalog")
    public ResponseData findDefaultAttributes(@RequestParam(name = "typeId") String typeId);
}