package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.config.response.ResponseData;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.CatalogView;
import cn.gtmap.gtc.resource.domain.resource.dto.tpl.Tpl;
import cn.gtmap.gtc.resource.domain.resource.metadata.Catalog;
import cn.gtmap.gtc.resource.domain.resource.metadata.CatalogDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;
import java.util.Map;

/**
 * CatalogClient
 *
 * @author monarchCheng
 * @create 2017-11-14 14:40
 **/
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/catalog")
public interface CatalogClient {

    /**
     * 查询根目录
     *
     * @param type
     * @return
     */
    @RequestMapping("/query/root/{type}")
    List<CatalogView> findRootCatalog(@PathVariable(name = "type") String type);

    /**
     * 默认根目录
     *
     * @return
     */
    @RequestMapping("/default/root")
    List<CatalogView> findRootCatalog();

    /**
     * find RootCatalog Groups
     *
     * @return
     */
    @GetMapping("/root/groups")
    Map findRootCatalogGroups();

    /**
     * find RootCatalog Groups
     *
     * @return
     */
    @GetMapping("/root/getDataDownloadCatalogGroups")
    Map getDataDownloadCatalogGroups();


    /**
     * 查询目录的子目录
     *
     * @param id
     * @return
     */
    @RequestMapping("/query/{id}/children")
    List<CatalogView> findChildCatalog(@PathVariable(name = "id") String id);


    /**
     * 查询所有目录
     *
     * @param parentId
     * @return
     */
    @GetMapping("/query/children/{parentId}")
    List<CatalogView> findByParentId(@PathVariable(name = "parentId") String parentId);

    /**
     * 根据类型查询目录
     *
     * @param type
     * @return
     */
    @RequestMapping("/query/type/{type}")
    List<Catalog> findCatalogByType(@PathVariable(name = "type") String type);


    /**
     * 根据id查询目录
     *
     * @param id
     * @return
     */
    @RequestMapping("/query/id/{id}")
    Catalog findCatalogById(@PathVariable(name = "id") String id);


    /**
     * 查询所有目录
     *
     * @return
     */
    @RequestMapping("/query/findAllCatalogByType/{type}")
    List<CatalogView> findAllCatalogByType(@PathVariable(name = "type") String type);

    /**
     * 资源类型编辑页面-查询所有资源类型
     */
    @RequestMapping("/query/findAllResourceType")
    List<CatalogView> findAllResourceType(@RequestParam(name = "type") String type);

    @GetMapping("/query/findParentByChild/{id}")
    public List findParentByChild(@PathVariable(name = "id") String id);

    /**
     * 保存catalog
     */
    @PostMapping("/saveCatalog")
    public Catalog saveCatalog(@RequestBody Catalog catalog);

    /**
     * 保存catalog
     */
    @PostMapping("/saveCatalogParams")
    public Catalog saveCatalogParams(@RequestBody Map params);

    /**
     * 删除catalog
     *
     * @param id
     */
    @RequestMapping("/deleteCatalog/{id}")
    public void deleteCatalog(@PathVariable(name = "id") String id);

    /**
     * 删除catalog
     *
     * @param type
     */
    @RequestMapping("/deleteCatalogByType/{type}")
    public void deleteCatalogByType(@PathVariable(name = "type") String type);

    /**
     * 删除ref
     *
     * @param id
     */
    @RequestMapping("/deleteRef/{id}")
    public void deleteRef(@PathVariable(name = "id") String id);

    /**
     * 默认根目录
     *
     * @return
     */
    @GetMapping("/findAllRootCatalog/{parentId}")
    List<Catalog> findAllRootCatalog(@PathVariable(name = "parentId") String parentId);


    /**
     * 根据父目录查询catalog并统计其关联的资源总数
     * @param parentId
     * @return
     */
    @GetMapping("/findAllRootCatalogAndTotal/{type}/{parentId}")
    List<CatalogDto> findAllRootCatalogAndTotal(@PathVariable(name = "type") String type,@PathVariable(name = "parentId") String parentId);

    /**
     *
     */
    @GetMapping("/findCatRefList/{id}")
    List<String> findCatRefList(@PathVariable(name = "id") String id);

    /**
     * saveResToCat
     */
    @RequestMapping("/associate/catalogAndResource")
    public Catalog associateCatalogAndResources(@RequestParam(name = "catalogId") String catalogId,
                                                @RequestParam(name = "resources") String resourceIds,
                                                @RequestParam(name = "replaceAll", required = false) boolean replace);
    /**
     * saveResToCat
     */
    @RequestMapping("/updateCatalog")
    public Catalog updateCatalog(@RequestParam(name = "nodeArr") String nodeArr,@RequestParam(name = "type") String type);

    /**
     * removeResToCat
     */
    @RequestMapping("/remove/resource/ref")
    public Catalog removeCatalogAndResources(@RequestParam(name = "catalogId") String catalogId,
                                             @RequestParam(name = "resources") String resourceIds);


    /**
     * 统计分页根据 type = RESC来统计当前四大类下有多少资源数量
     *
     * @return key类别 value 数量
     */
    @GetMapping("/sourcesCount")
    Map<String, Integer> getSourcesCountByType();

    /**
     * 默认根目录
     *
     * @return
     */
    @GetMapping("/findCatalogIdsByIds/{catalogIds}")
    List<Catalog> findCatalogIdsByIds(@PathVariable(name = "catalogIds") String catalogIds);
    @PostMapping("/copyCatalogs")
    Object copyCatalogs(@RequestBody Map map);

    @RequestMapping("/saveCatalogAndTplRef")
    Object saveCatTplRef(@RequestParam(name = "catalogId", required = false) String catalogId,
                         @RequestParam(name = "tplIds", required = false) String tplIds,
                         @RequestParam(name = "replace", required = false) boolean replace);

    @RequestMapping("/findTplsByCatalogId")
    List<Tpl> findTplsByCatalogId(@RequestParam(name = "catalogId", required = false) String catalogId);

    @RequestMapping("/findCatalogsByTplId")
    List<Catalog> findCatalogsByTplId(@RequestParam(name = "tplId", required = false) String tplId);

    @RequestMapping("/queryCatalogs")
    List<Catalog> queryCatalogs(@RequestParam(name="catTypes",required = false) String catTypes);

    /**
     * 历史数据处理
     *
     * @return
     */
    @RequestMapping("/handleCatResData")
    public boolean handleCatResData();

    /**
     * 组织json树
     *
     * @return
     */
    @RequestMapping("/buildJSONTree")
    public String buildJSONTree(@RequestParam(name = "type", required = false) String type);

    @RequestMapping("/buildJSONTreeByRole")
    public String buildJSONTreeByRole(@RequestParam(name = "type", required = false) String type,
                                      @RequestParam(name = "roleId", required = false) String roleId);

    @GetMapping("/queryRootCatalogByType/{type}")
    public Catalog queryRootCatalogByType(@PathVariable(name = "type") String type);

    /**
     * 资源详情页面，获取每种资源类型的扩展属性
     *
     * @return ResponseData
     */
    @GetMapping("/getResTypeAppendAttr")
    public ResponseData getResTypeAppendAttr(@RequestParam("type")String catalogId);

    /**
     * 查询parent_id=0并且type为指定类型的catalog是否存在
     * @param type
     * @return
     */
    @GetMapping("/getCountByPidAndType")
    public Boolean getCountByPidAndType(@RequestParam("type") String type);

    //根据title和type删除
//    Map deleteByTitileAndType(String title,String type);
//
//    List<Catalog> queryServiceTemplateByTitleAndType(String title,String type);
//
//    List<Catalog> getAllCatalogsByType(String type);
}
