package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Attachment;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/attachment")
public interface AttacnmentClient {

    /**
     * 保存附件信息
     * @param serverid  地图服务代理id
     * @param layerid   图层在服务中的id
     * @param featureid 地块id
     * @param storageid 存储文件id
     * @param filename  文件名
     * @return
     */
    @PostMapping(value = "/uploadAttachment")
    Boolean uploadAttachment(
            @RequestParam(name = "serverid") String serverid,
            @RequestParam(name = "layerid") String layerid,
            @RequestParam(name = "featureid") String featureid,
            @RequestParam(name = "storageid") String storageid,
            @RequestParam(name = "filename") String filename);

    /**
     * 根据地块获取对应附件
     * @param serverid  地图服务代理id
     * @param layerid   图层在服务中的id
     * @param featureid 地块id
     * @return
     */
    @GetMapping("/getAttachmentsByFeature")
    List<Attachment> getAttachmentsByFeature(
            @RequestParam(name = "serverid") String serverid,
            @RequestParam(name = "layerid") String layerid,
            @RequestParam(name = "featureid") String featureid);

    /**
     * 删除附件
     * @param id    附件id
     * @return
     */
    @GetMapping("/deleteAttachment")
    Map deleteAttachment(@RequestParam(name = "id") String id);
}
