package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Announcement;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/3/27.
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/announcement")
public interface AnnouncementClient {
    @GetMapping("/getAnnouncementByPage")
    Page<Announcement> getAnnouncementByPage(@RequestParam(name = "title") String title, Pageable pageable);

    @GetMapping("/getAnnouncementByPublisher")
    Page<Announcement> getAnnouncementByPublisher(@RequestParam(name = "title") String title, @RequestParam(name = "username") String username, Pageable pageable);

    /**
     * 保存公告以及它的转发信息
     * @param announcementAndRelation 一个Map集合，包括announcement数据和它的公开/发送对象等信息
     * announcementAndRelation = {
     *     "data": 存放announcement类
     *     "isPublic": true/false 是否是公开的
     *     "sendUser": 指定发送的用户字符串，逗号分隔
     *     "sendDepartment"： 指定发送的部门，逗号分隔
     * }
     */
    @PostMapping("/saveAnnouncementAndRelation")
    Boolean saveAnnouncementAndRelation(@RequestBody Map announcementAndRelation);

    @PostMapping("/saveAnnouncement")
    Boolean saveAnnouncement(@RequestBody Announcement announcement);

    @PostMapping("/updateAnnouncementSort")
    Boolean updateAnnouncementSort(@RequestParam(name="ids") String ids);

    @RequestMapping("/deleteAnnouncement")
    public Boolean deleteAnnouncement(@RequestParam(name = "id") String id);

    @RequestMapping("/findAnnouncement")
    public Announcement findAnnouncement(@RequestParam(name = "id") String id);

    @RequestMapping("/updateAnnouncement")
    public boolean updateAnnouncement(@RequestBody Announcement announcement);

    @RequestMapping("/findMaxWeight")
    public Integer findMaxWeight();

    @RequestMapping("/findAnnouncementsByTop")
    public List<Announcement> findAnnouncementsByTop();

    /**
     * 单个用户查询接收公告
     * 公告表receivedType==special且公告关系表中用户id对应的公告+
     * 公告表receivedType==NULL的公告+
     * 公告表receivedType==用户角色的公告
     *
     * @param username 用户名
     * @param title 公告标题
     * @param pageable 分页数据
     * @return Page<Announcement>
     */
    @GetMapping("/queryLimitAnnouncement")
    Page<Announcement> getPersonalAnnounce(@RequestParam(name = "username") String username, @RequestParam(name = "title", required = false) String title, Pageable pageable);

    /**
     * 单个用户查询接收公告，取最新的一条公告
     * 公告表receivedType==special且公告关系表中用户id对应的公告+
     * 公告表receivedType==NULL的公告+
     * 公告表receivedType==用户角色的公告
     *
     * @param userName 用户名
     * @return List<Announcement>
     */
    @GetMapping("/queryLimitAnnouncementTop")
    List<Announcement> getPersonalAnnouncementTop(@RequestParam(name = "username") String userName);

    /**
     * 单个用户查询接收公告，查询近期规定时间内的公告
     * 公告表receivedType==special且公告关系表中用户id对应的公告+
     * 公告表receivedType==NULL的公告+
     * 公告表receivedType==用户部门的公告
     *
     * @param username     用户id
     * @param recentDayNum 近期的查询天数,不写默认7天
     * @return List<Announcement>
     */
    @GetMapping("/queryLimitAnnouncementRecent")
    List<Announcement> getPersonalAnnouncementRecent(@RequestParam(name = "username") String username, @RequestParam(name = "recentDayNum", required = false, defaultValue = "7") String recentDayNum);
}
