package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Advice;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

/**
 * @author gt-weiran
 * @date 2020-12-12-15:20
 * version
 * illustration
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/advice")
public interface AdviceClient {
    /**
     * 根据条件和权限查询意见列表
     * @param conditionStr
     * @return
     */
    @GetMapping("/query/condition")
    Page<Advice> getAdvice(@RequestParam(name = "condition") String conditionStr);

    /**
     * 更新意见
     * @param advice
     * @return
     */
    @PostMapping("/save")
    Boolean saveAdvice(@RequestBody Advice advice);

    /**
     * 删除意见
     * @param id
     * @return
     */
    @PostMapping("/delete")
    Boolean deleteAdvice(@RequestParam(name = "id") String id);
}
