package cn.gtmap.gtc.resource.clients.mdb;

import cn.gtmap.gtc.resource.domain.mdb.ResultBean;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * dataStore client
 *
 * @author zzy
 * @create 2019-09-03 10:47
 **/
@FeignClient(name="${app.services.mdb-app:mdb-app}")
@RequestMapping("/mdb/v1/datastore/")
public interface DataStoreClient {

    @GetMapping("features/map")
    public ResultBean queryFeatures(@RequestParam(name = "tableId") String tableId,
                                    @RequestParam(name = "outFields", required = false) String[] outFields,
                                    @RequestParam(name = "where") String where);
}
