package cn.gtmap.gtc.resource.clients.filecenter;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;

@FeignClient(name="${app.services.resource-filecenter:resource-filecenter}")
@RequestMapping("/fileCenter")
public interface FileCenterClient {

    /**
     * 获取当前行政区划下所有的文件列表
     *
     * @param name 行政区划名称
     * @return
     */
    @GetMapping("/getFiles")
    public List<Map<String, String>> getFileList(@RequestParam(name = "name") String name,
                                                 @RequestParam(name = "typeName",required = false) String typeName,
                                                 @RequestParam(name = "level") int node) throws IOException;

    /**
     * 扫描对应文件夹，获取图件数据
     * @param typeName
     * @return
     */
    @RequestMapping("/getFileXmlData")
    public List<Map> getFileXmlData(@RequestParam(name = "typeName",required = false) String typeName);

    /**
     * 扫描文档中心配置
     * @param username
     * @return
     */
    @RequestMapping("/scanStorageFiles")
    public void scanStorageFiles(@RequestParam(name = "username") String username);

    /**
     * 根据id扫描文档中心配置
     * @param username
     * @param id
     * @return
     */
    @RequestMapping("/scanStorageFileById")
    public void scanStorageFileById(@RequestParam(name = "username") String username, @RequestParam(name = "id") String id);

    /**
     * 旧版文档中心搜索
     */
    @PostMapping("/searchFiles")
    public List<String> searchFiles(@RequestBody Map params);

}
