package cn.gtmap.gtc.resource.clients.display;

import cn.gtmap.gtc.resource.config.response.ResponseData;
import cn.gtmap.gtc.resource.domain.resource.metadata.excellentplan.ExcellentPlan;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/excellent")
public interface ExcellentPlanClient {

    /**
     * 查询列表（带条件）
     * @param proName
     * @param orgName
     * @param pageable
     * @return
     */
    @PostMapping("/getPlanList")
    public ResponseData getPlanList(@RequestParam("proName") String proName, @RequestParam("orgName") String orgName, @RequestParam("distinctKey") String distinctKey,Pageable pageable);

    /**
     * 编辑评选信息
     * @param excellentPlan
     * @return
     */
    @PostMapping("/editPlanInfo")
    public ResponseData editPlanInfo(@RequestBody ExcellentPlan excellentPlan);

    /**
     * 删除评选信息
     * @param ids
     * @return
     */
    @PostMapping("/deletePlan")
    public ResponseData deletePlan(@RequestParam("ids") String ids);

    /**
     * 添加评选信息
     * @param excellentPlan
     * @return
     */
    @PostMapping("/addPlanInfo")
    public ResponseData addPlan(@RequestBody ExcellentPlan excellentPlan);

    /**
     * 批量导入
     * @param file
     * @return
     */
    @PostMapping(value="/uploadPlanList",produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public ResponseData uploadPlanList(@RequestPart(name = "file") MultipartFile file);

    /**
     * 批量下载
     * @param ids
     * @return
     */
    @PostMapping("/downloadPlanList")
    public ResponseData downLoadPlanList(@RequestParam("ids") String ids);

    /**
     * 获取单位名称列表
     * @return
     */
    @GetMapping("/getOrgNameDict")
    public List<String> getOrgNameDict();
}
