package cn.gtmap.gtc.resource.clients.display;

import cn.gtmap.gtc.resource.domain.resource.metadata.display.DisplayCenter;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * display client
 *
 * @author yhj
 * @create 2017-11-14 10:47
 **/
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/display")
public interface DisplayCenterClient {

    @RequestMapping("/query/businessRoleId")
    public List<DisplayCenter> findByBusinessQuery(@RequestParam(name = "business", required = false) String business,
                                              @RequestParam(name = "roleId", required = false) String roleId);

    /**
     * 根据业务查询
     * @param business
     * @return
     */
    @RequestMapping("/query/business/{business}")
    public List<DisplayCenter> findByBusiness(@PathVariable("business") String business);

    /**
     * 根据业务分页查询
     * @param business
     * @param pageable
     * @return
     */
    @RequestMapping("/query/business")
    public Page<DisplayCenter> findByBusiness(@RequestParam("business") String business, Pageable pageable);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    @RequestMapping("/query/id/{id}")
    public DisplayCenter findById(@PathVariable("id") String id);

    /**
     * 保存列表
     * @param displayCenterList
     * @return
     */
    @PostMapping("/save")
    public List<DisplayCenter> save(@RequestBody List<DisplayCenter> displayCenterList);

    /**
     * 根据id删除
     * @param id
     */
    @RequestMapping("/delete/{id}")
    public void delete(@PathVariable("id") String id);

    /**
     * @Author: 张帅杰
     * 15:24 2019/5/23
     * @return: java.lang.String
     * @param: roleId
     * @param: displayCenterId
     * PS:角色——展示中心权限信息保存
     **/
    @PostMapping("/save/saveRoleDisplayRef")
    void saveRoleDisplayRef(@RequestBody Map params);

    @PostMapping("/save/saveRoleDisplayRefShow")
    void saveRoleDisplayRefShow(@RequestBody Map params);

    /**
     * @Author: 张帅杰
     * 15:25 2019/5/23
     * @return: java.util.List<java.lang.String>
     * @param: roleId
     * PS:依据角色id，查询所拥有的展示中心权限
     **/
    @PostMapping("/query/queryRoleDisplayRef")
    List<String> queryRoleDisplayRef(@RequestParam(name = "roleId", required = false) String roleId);

    @PostMapping("/query/queryRoleDisplayRefShow")
    List<String> queryRoleDisplayRefShow(@RequestParam(name = "roleId", required = false) String roleId);

    /**
     * @Author: 张帅杰
     * 15:25 2019/5/23
     * @return: java.util.List<java.util.List>
     * @param: roleAlias
     * PS:依据角色alias查询符合条件的角色
     **/
    @RequestMapping("/query/queryByRoleAlias")
    List<List> queryByRoleAlias(@RequestParam(name = "roleAlias", required = false) String roleAlias);

}
