/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.Work;
import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.domain.define.WorkDayRelation;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.services.bpm-define:bpm-define}")
@RequestMapping(value={"define/v1"})
public interface WorkDayClient {
    @RequestMapping(value={"/works"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<Work> getWorks();

    @RequestMapping(value={"/works/Condition"}, method={RequestMethod.GET}, produces={"application/json"})
    public Page<Work> getWorksByCondition(@RequestParam(value="name") String var1, Pageable var2);

    @RequestMapping(value={"/works"}, method={RequestMethod.POST})
    public void saveWork(@RequestBody Work var1);

    @RequestMapping(value={"/works/{id}"}, method={RequestMethod.DELETE})
    public void delWork(@PathVariable(value="id") String var1);

    @RequestMapping(value={"/works/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Work getWork(@PathVariable(value="id") String var1);

    @RequestMapping(value={"/works/{id}/sub"}, method={RequestMethod.DELETE})
    public void delWorkAndSub(@PathVariable(value="id") String var1);

    @RequestMapping(value={"/works/{workId}/work-days"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<WorkDay> getWorkDays(@PathVariable(value="workId") String var1, @RequestParam(value="startDate") String var2, @RequestParam(value="endDate") String var3);

    @RequestMapping(value={"/works/{workId}/work-days/page"}, method={RequestMethod.GET}, produces={"application/json"})
    public Page<WorkDay> getWorkDaysByPage(@PathVariable(value="workId") String var1, Pageable var2);

    @RequestMapping(value={"/work-days/only"}, method={RequestMethod.POST})
    public void saveWorkDay(@RequestBody WorkDay var1);

    @RequestMapping(value={"/work-days"}, method={RequestMethod.DELETE})
    public void delWorkDay(@RequestBody List<String> var1);

    @RequestMapping(value={"/work-days/{id}"}, method={RequestMethod.GET})
    public WorkDay getWorkDay(@PathVariable(value="id") String var1);

    @RequestMapping(value={"/work-days/{workId}"}, method={RequestMethod.DELETE})
    public void delWorkDayByWorkId(@PathVariable(value="workId") String var1);

    @RequestMapping(value={"/work-days/workDays"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<WorkDay> findWorkDaysByRelationId(@RequestParam(value="relationId") String var1, @RequestParam(value="type") Integer var2);

    @RequestMapping(value={"/works/relation"}, method={RequestMethod.POST})
    public void saveWorkRelation(@RequestBody WorkDayRelation var1);

    @RequestMapping(value={"/workday-relation/workDayRelation"}, method={RequestMethod.GET})
    public WorkDayRelation findWorkDayRelation(@RequestParam(value="relationId") String var1, @RequestParam(value="type") Integer var2);

    @RequestMapping(value={"/work_relation/{id}"}, method={RequestMethod.DELETE})
    public void delWorkRelation(@PathVariable(value="id") String var1);

    @RequestMapping(value={"/work-days/batch"}, method={RequestMethod.POST})
    public void batchSaveWorkdays(@RequestBody List<WorkDay> var1);

    @RequestMapping(value={"/work-days/workday-count"}, method={RequestMethod.GET})
    public Integer getWorkDayCount(@RequestParam(value="workId") String var1, @RequestParam(value="sDay") String var2, @RequestParam(value="eDay") String var3);

    @RequestMapping(value={"/work-days/batch"}, method={RequestMethod.DELETE})
    public void batchDelWorkDay(@RequestParam(value="workId") String var1, @RequestParam(value="sDay") String var2, @RequestParam(value="eDay") String var3);
}

