/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.Model;
import cn.gtmap.gtc.workflow.domain.define.dmn.DecisionTableDto;
import cn.gtmap.gtc.workflow.domain.define.dmn.DecisionTableSaveDto;
import cn.gtmap.gtc.workflow.domain.define.rest.ModelRepresentationView;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(value="${app.services.bpm-define:bpm-define}")
@RequestMapping(value={"define/v1"})
public interface DmnModelClient {
    @RequestMapping(value={"/dmn-models/list"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<DecisionTableDto> getDecisionTables(@RequestBody String[] var1);

    @RequestMapping(value={"/dmn-models/{decisionTableId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public DecisionTableDto getDecisionTable(@PathVariable(value="decisionTableId") String var1);

    @RequestMapping(value={"/dmn-models/{decisionTableId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public DecisionTableDto saveDecisionTable(@PathVariable(value="decisionTableId") String var1, @RequestParam(value="userId") String var2, @RequestBody DecisionTableSaveDto var3);

    @RequestMapping(value={"/dmn-models"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<Model> getDecisionTables(@RequestParam(value="filter", required=false) String var1);

    @RequestMapping(value={"/dmn-models/{modelId}/dmn"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getDmnModelBpmn20Xml(@PathVariable(value="modelId") String var1);

    @RequestMapping(value={"/dmn-models/history/{modelHistoryId}/dmn"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getHistoricDmnBpmn20Xml(@PathVariable(value="modelHistoryId") String var1);

    @RequestMapping(value={"/dmn-models/upload"})
    @ResponseBody
    public ModelRepresentationView importDmnModel(@RequestParam(value="userId") String var1, @RequestParam(value="file") MultipartFile var2);

    @RequestMapping(value={"/dmn-models/upload/text"}, method={RequestMethod.POST})
    public String importDmnModelText(@RequestParam(value="userId") String var1, @RequestParam(value="file") MultipartFile var2);

    @RequestMapping(value={"/dmn-models/{modelId}/deployment"}, method={RequestMethod.GET})
    public void deploymentDmn(@PathVariable(value="modelId") String var1);
}

