/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class.getClass());

    public static void zipFile(String zip, List<File> srcFiles) {
        if (CollectionUtils.isNotEmpty(srcFiles)) {
            ZipUtil.zipFile(zip, srcFiles.toArray(new File[0]));
        }
    }

    public static void zipFile(String zip, File[] srcFiles) {
        try {
            if (zip.endsWith(".zip") || zip.endsWith(".zip".toUpperCase())) {
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zip)));
                zipOut.setEncoding("utf-8");
                for (File file : srcFiles) {
                    ZipUtil.handlerFile(zip, zipOut, file, "");
                }
                zipOut.close();
            } else {
                System.out.println("target file[" + zip + "] is not .zip type file");
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void handlerFile(String zip, ZipOutputStream zipOut, File srcFile, String path) throws IOException {
        System.out.println(" begin to compression file[" + srcFile.getName() + "]");
        if (!"".equals(path) && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if (!srcFile.getPath().equals(zip)) {
            if (srcFile.isDirectory()) {
                File[] files = srcFile.listFiles();
                if (files.length == 0) {
                    zipOut.putNextEntry(new ZipEntry(path + srcFile.getName() + File.separator));
                    zipOut.closeEntry();
                } else {
                    for (File file : files) {
                        ZipUtil.handlerFile(zip, zipOut, file, path + srcFile.getName());
                    }
                }
            } else {
                FileInputStream inputStream = new FileInputStream(srcFile);
                zipOut.putNextEntry(new ZipEntry(path + srcFile.getName()));
                int len = 0;
                byte[] bytes = new byte[1024];
                while ((len = ((InputStream)inputStream).read(bytes)) > 0) {
                    zipOut.write(bytes, 0, len);
                }
                ((InputStream)inputStream).close();
                zipOut.closeEntry();
            }
        }
    }

    public static void zipFile(String zip, List<File> files, List<String> fileNameList) {
        try {
            if (zip.endsWith(".zip") || zip.endsWith(".zip".toUpperCase())) {
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zip)));
                zipOut.setEncoding("utf-8");
                for (int i = 0; i < files.size(); ++i) {
                    ZipUtil.handlerFile(zipOut, files.get(i), "", fileNameList.get(i));
                }
                zipOut.close();
            } else {
                System.out.println("target file[" + zip + "] is not .zip type file");
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void handlerFile(ZipOutputStream zipOut, File srcFile, String path, String fileName) throws IOException {
        System.out.println(" begin to compression file[" + fileName + "]");
        if (!"".equals(path) && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        zipOut.putNextEntry(new ZipEntry(path + fileName));
        int len = 0;
        byte[] bytes = new byte[1024];
        FileInputStream inputStream = new FileInputStream(srcFile);
        while ((len = inputStream.read(bytes)) > 0) {
            zipOut.write(bytes, 0, len);
        }
        inputStream.close();
        zipOut.closeEntry();
    }

    public static List<File> upzipFile(String zipPath, String descDir) {
        return ZipUtil.upzipFile(new File(zipPath), descDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> upzipFile(File zipFile, String descDir) {
        ArrayList<File> fileList = new ArrayList<File>();
        ZipFile resultZipFile = null;
        try {
            resultZipFile = new ZipFile(zipFile, "utf-8");
            Enumeration entries = resultZipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File file = new File(descDir + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                InputStream inputStream = resultZipFile.getInputStream(entry);
                FileOutputStream outputStream = new FileOutputStream(file);
                int len = 0;
                byte[] bytes = new byte[1024];
                while ((len = inputStream.read(bytes)) > 0) {
                    ((OutputStream)outputStream).write(bytes, 0, len);
                }
                inputStream.close();
                outputStream.flush();
                ((OutputStream)outputStream).close();
                fileList.add(file);
            }
        }
        catch (IOException e) {
            logger.error("\u89e3\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (resultZipFile != null) {
                try {
                    resultZipFile.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edzip\u6587\u4ef6\u6d41\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                }
            }
        }
        return fileList;
    }

    public static File doZip(String zipDirectory, String zipPath) {
        File zipDir = new File(zipDirectory);
        if (zipPath == null) {
            zipPath = zipDir.getParent();
        }
        String zipFileName = zipPath + "\\" + zipDir.getName() + ".zip";
        try {
            ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipFileName)));
            ZipUtil.handleDir(zipDir, zipDir.getParent().length() + 1, zipOut);
            zipOut.close();
            return new File(zipFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private static void handleDir(File dir, int len, ZipOutputStream zipOut) throws IOException {
        FileInputStream fileIn = null;
        File[] files = dir.listFiles();
        if (files != null) {
            if (files.length > 0) {
                for (File fileName : files) {
                    int readedBytes;
                    if (fileName.isDirectory()) {
                        ZipUtil.handleDir(fileName, len, zipOut);
                        continue;
                    }
                    fileIn = new FileInputStream(fileName);
                    byte[] buf = new byte[fileIn.available()];
                    zipOut.putNextEntry(new ZipEntry(fileName.getPath().substring(len + dir.getName().length()).replaceAll("\\\\", "")));
                    while ((readedBytes = fileIn.read(buf)) > 0) {
                        zipOut.write(buf, 0, readedBytes);
                    }
                    zipOut.closeEntry();
                    fileIn.close();
                }
            } else {
                zipOut.putNextEntry(new ZipEntry(dir.getPath().substring(len) + "/"));
                zipOut.closeEntry();
            }
        } else {
            int readedBytes;
            fileIn = new FileInputStream(dir);
            byte[] buf = new byte[fileIn.available()];
            zipOut.putNextEntry(new ZipEntry(dir.getPath().substring(len)));
            while ((readedBytes = fileIn.read(buf)) > 0) {
                zipOut.write(buf, 0, readedBytes);
            }
            zipOut.closeEntry();
            fileIn.close();
        }
    }
}

