/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WorkDayUtil {
    public static String getDateByAddDays(String day, int num) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = null;
        try {
            nowDate = df.parse(day);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date newDate2 = new Date(nowDate.getTime() + (long)num * 24L * 60L * 60L * 1000L);
        String dateOk = df.format(newDate2);
        return dateOk;
    }

    public static String getDateByDelDays(String day, int num) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = null;
        try {
            nowDate = df.parse(day);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date newDate2 = new Date(nowDate.getTime() - (long)num * 24L * 60L * 60L * 1000L);
        String dateOk = df.format(newDate2);
        return dateOk;
    }

    public static Map<String, Object> getDueDateNum(Date dueDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        Date dayDate = null;
        Date hourDate = null;
        try {
            dayDate = df.parse("2000-01-01");
            hourDate = df.parse("2100-01-01");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (dueDate.getTime() > hourDate.getTime()) {
            result.put("type", (Object)ComputeMode.Hour);
            int num = (int)((dueDate.getTime() - hourDate.getTime()) / 86400000L);
            result.put("num", num);
        } else {
            result.put("type", (Object)ComputeMode.Day);
            int num = (int)((dueDate.getTime() - dayDate.getTime()) / 86400000L);
            result.put("num", num);
        }
        return result;
    }

    public static Map<String, Object> getDueDateNum(String dueDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = df.parse(dueDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return WorkDayUtil.getDueDateNum(date);
    }

    public static enum ComputeMode {
        Day(2, "\u6309\u5929\u8ba1\u7b97"),
        Hour(1, "\u6309\u5c0f\u65f6\u8ba1\u7b97"),
        None(0, "\u4e0d\u8ba1\u7b97");

        private int value;
        private String remark;

        private ComputeMode(int value, String remark) {
            this.value = value;
            this.remark = remark;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public static ComputeMode getByValue(int value) {
            for (ComputeMode computeMode : ComputeMode.values()) {
                if (computeMode.value != value) continue;
                return computeMode;
            }
            return null;
        }
    }
}

