/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelUtils {
    public static HSSFWorkbook buildXlsWorkBook(HSSFWorkbook wb, String sheetName, String[] title, String[][] values, boolean adaptive) {
        int i;
        if (wb == null) {
            wb = new HSSFWorkbook();
        }
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBoldweight((short)700);
        font.setFontHeightInPoints((short)11);
        style.setFont(font);
        HSSFCell cell = null;
        for (i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle(style);
        }
        if (values != null) {
            for (i = 0; i < values.length; ++i) {
                row = sheet.createRow(i + 1);
                for (int j = 0; j < values[i].length; ++j) {
                    row.createCell(j).setCellValue(values[i][j]);
                }
            }
        }
        if (adaptive) {
            for (i = 0; i < title.length; ++i) {
                sheet.autoSizeColumn((int)((short)i));
            }
        }
        return wb;
    }

    public static HSSFWorkbook buildXlsWorkBook(HSSFWorkbook wb, String sheetName, String[] title, String[] fieldNames, List<Object> list, boolean adaptive) {
        if (CollectionUtils.isEmpty(list)) {
            return ExcelUtils.buildXlsWorkBook(wb, sheetName, title, null, adaptive);
        }
        String[][] arr = new String[list.size()][fieldNames.length];
        int i = 0;
        for (Object obj : list) {
            String[] sarr = new String[fieldNames.length];
            boolean j = false;
            for (String fieldName : fieldNames) {
                String value = "";
                Class<?> clazz = obj.getClass();
                Field field = ExcelUtils.getFieldInClass(clazz, fieldName);
                if (field != null) {
                    field.setAccessible(true);
                    try {
                        value = ExcelUtils.convertToString(field, obj);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                sarr[i++] = value;
            }
            arr[i++] = sarr;
        }
        return ExcelUtils.buildXlsWorkBook(wb, sheetName, title, arr, adaptive);
    }

    private static String convertToString(Field field, Object obj) throws IllegalAccessException {
        if (field.getType().isPrimitive()) {
            return String.valueOf(field.get(obj));
        }
        String fieldClassName = field.getType().getName();
        if (fieldClassName.equals(String.class.getName()) || fieldClassName.equals(Short.class.getName()) || fieldClassName.equals(Integer.class.getName()) || fieldClassName.equals(Long.class.getName()) || fieldClassName.equals(Float.class.getName()) || fieldClassName.equals(Double.class.getName()) || fieldClassName.equals(Number.class.getName()) || fieldClassName.equals(Character.class.getName())) {
            return String.valueOf(field.get(obj));
        }
        if (fieldClassName.equals(java.util.Date.class.getName())) {
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return datetimeFormat.format(field.get(obj));
        }
        if (fieldClassName.equals(Date.class.getName())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return dateFormat.format(field.get(obj));
        }
        if (fieldClassName.equals(Time.class.getName())) {
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            return timeFormat.format(field.get(obj));
        }
        return obj.toString();
    }

    private static Field getFieldInClass(Class clazz, String fieldName) {
        Field field = null;
        while (clazz != Object.class & field == null) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return field;
    }
}

