/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.RuIdentitylink;
import cn.gtmap.gtc.workflow.domain.manage.RuTask;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import java.util.HashMap;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="bpm-manage")
@RequestMapping(value={"manage/v1"})
public interface ProcessTaskClient {
    @RequestMapping(value={"/process-tasks/task-list-addition"}, method={RequestMethod.GET})
    public HashMap<String, Object> taskCreateList();

    @RequestMapping(value={"/process-tasks/count"}, method={RequestMethod.GET})
    public Integer claimTaskCount(@RequestParam(value="userId", required=false) String var1);

    @RequestMapping(value={"/process-tasks/task-list-unclaimed"}, method={RequestMethod.GET})
    public Page<TaskData> claimTaskList(@RequestParam(value="userId", required=false) String var1, @RequestParam(value="category", required=false) String var2, @RequestParam(value="processInstanceName", required=false) String var3, Pageable var4);

    @RequestMapping(value={"/process-tasks/task-list-undoned"}, method={RequestMethod.GET})
    public Page<TaskData> todoTaskList(@RequestParam(value="userId", required=false) String var1, @RequestParam(value="category", required=false) String var2, @RequestParam(value="processInstanceName", required=false) String var3, Pageable var4);

    @RequestMapping(value={"/process-tasks/task-list-finished"}, method={RequestMethod.GET})
    public Page<TaskData> completeTaskList(@RequestParam(value="userId") String var1, @RequestParam(value="category") String var2, @RequestParam(value="processInstanceName") String var3, Pageable var4);

    @RequestMapping(value={"/process-tasks/start-process-instance"}, method={RequestMethod.POST})
    public RuTask getTaskByInstanceId(@RequestParam(value="processDefId") String var1, @RequestParam(value="processKey") String var2, @RequestParam(value="userId") String var3, @RequestParam(value="userName") String var4, @RequestParam(value="processName") String var5) throws Exception;

    @RequestMapping(value={"/process-tasks/{taskId}/task-idm"}, method={RequestMethod.GET})
    public List<RuIdentitylink> getIdentityByTaskId(@PathVariable(value="taskId") String var1) throws Exception;

    @RequestMapping(value={"/process-tasks/{userId}/claim"}, method={RequestMethod.POST})
    public String taskClaim(@RequestParam(value="userId") String var1, @RequestBody List<String> var2);

    @RequestMapping(value={"/process-tasks/{taskId}/{processInstanceId}/{userName}/{endUserTaskFlag}/{parallelBackType}/{forwardType}/complete"}, method={RequestMethod.POST})
    public String taskForward(@PathVariable(value="taskId") String var1, @PathVariable(value="processInstanceId") String var2, @PathVariable(value="userName") String var3, @PathVariable(value="endUserTaskFlag") Boolean var4, @PathVariable(value="parallelBackType") String var5, @PathVariable(value="forwardType") String var6);

    @RequestMapping(value={"/process-tasks/{taskId}/fallback"}, method={RequestMethod.GET})
    public String taskRecaption(@PathVariable(value="taskId") String var1);

    @RequestMapping(value={"/process-tasks/{processInstanceId}"}, method={RequestMethod.DELETE})
    public String taskDelete(@PathVariable(value="processInstanceId") String var1);

    @RequestMapping(value={"/process-tasks/{taskId}/{userId}/delegation"}, method={RequestMethod.POST})
    public String taskDelegationAndAgency(@PathVariable(value="taskId") String var1, @PathVariable(value="userId") String var2);

    @RequestMapping(value={"/process-tasks/{taskId}/complete-delegation"}, method={RequestMethod.POST})
    public String handleAgentTask(@PathVariable(value="taskId") String var1);

    @RequestMapping(value={"/processInstanceManage"}, method={RequestMethod.GET})
    public Object createNativeProcessInstanceQuery();

    @RequestMapping(value={"/process-tasks/{processInstanceId}/task-suspension"}, method={RequestMethod.POST})
    public String taskHang(@PathVariable(value="processInstanceId") String var1);

    @RequestMapping(value={"/process-tasks/{processInstanceId}/task-activate"}, method={RequestMethod.POST})
    public String taskActivation(@PathVariable(value="processInstanceId") String var1);

    @RequestMapping(value={"/process-tasks/{processInstanceId}/{deleteReason}/task-discard"}, method={RequestMethod.POST})
    public String taskAbandoned(@PathVariable(value="processInstanceId") String var1, @PathVariable(value="deleteReason") String var2);

    @RequestMapping(value={"/process-tasks/{taskId}/{state}/task-locked"}, method={RequestMethod.POST})
    public String taskLock(@PathVariable(value="taskId") String var1, @PathVariable(value="state") int var2);

    @RequestMapping(value={"/process-tasks/{taskId}/{state}/task-relieved"}, method={RequestMethod.POST})
    public String taskUnLock(@PathVariable(value="taskId") String var1, @PathVariable(value="state") int var2);
}

