/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.utilclient.common.client.rest;

import cn.gtmap.gtc.utilclient.common.dto.ProvinceCityCountyDTO;
import cn.gtmap.gtc.utilclient.common.dto.RegionDTO;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="util-center")
@RequestMapping(value={"/util/rest/config/region"})
public interface RegionManagerClient {
    @PostMapping
    public RegionDTO createRegion(@RequestBody RegionDTO var1);

    @PostMapping(value={"/import"})
    public boolean importRegions(@RequestBody List<RegionDTO> var1);

    @PutMapping
    public RegionDTO updateRegion(@RequestBody RegionDTO var1);

    @DeleteMapping(value={"/{id}"})
    public boolean deleteRegion(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/disable"})
    public boolean disableRegion(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/enable"})
    public boolean enableRegion(@PathVariable(name="id") String var1);

    @GetMapping(value={"/level"})
    public List<RegionDTO> findRegionsByLevel(@RequestParam(name="level") int var1);

    @GetMapping(value={"/code"})
    public RegionDTO findRegionByCode(@RequestParam(name="code") String var1);

    @GetMapping(value={"/name"})
    public RegionDTO findRegionByName(@RequestParam(name="name") String var1);

    @GetMapping(value={"/{code}/code-only"})
    public boolean validOnlyCode(@RequestParam(name="id", required=false) String var1, @PathVariable(name="code") String var2);

    @GetMapping(value={"/{id}"})
    public RegionDTO findRegionById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}/province-city-county"})
    public ProvinceCityCountyDTO getProCityCounty(@PathVariable(name="id") String var1);

    @GetMapping(value={"/root"})
    public List<RegionDTO> findRootRegions();

    @GetMapping(value={"/root/enabled"})
    public List<RegionDTO> findRootRegionsEnabled();

    @GetMapping(value={"/{id}/junior"})
    public List<RegionDTO> findJuniorRegions(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}/junior/enabled"})
    public List<RegionDTO> findJuniorRegionsEnabled(@PathVariable(name="id") String var1);
}

