package cn.gtmap.gtc.utilclient.common.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/9/4
 * @description
 */


@Data
public class SignDTO implements Serializable,Comparable<SignDTO> {

    private static final long serialVersionUID = 5649511174884480140L;
    // 主键
    private String id;

    // 流程实例ID
    private String processInsId;

    // 标志key
    private String signKey;

    // 用户账号
    private String username;

    // 中文名称
    private String userAlias;

    //意见
    private String signOpinion;

    //签名ID
    private String pictureId;

    private Integer order = -1;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;

    @Override
    public int compareTo(SignDTO o) {
        return this.order - o.order;
    }
}
