package cn.gtmap.gtc.utilclient.common.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 行政区
 * @author 杨红杰
 * @date 2019/6/25
 */
@Data
public class RegionDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 主键.*/
    private String id;

    /** 编码.*/
    private String code;

    /** 名称.*/
    private String name;

    /** 等级 1：省 2：市 3：区/县  4：乡镇.*/
    private int level;

    /** 是否禁用 1：是 0：否.*/
    private int enabled;

    /** 上一级主键.*/
    private String parentId;

    /** 上一级编码.*/
    private String parentCode;

    /** 上一级名称.*/
    private String parentName;

    /** 空间信息.*/
    private String spatialInfo;

    /**  是否拥有子集， 根据ztree 定义.*/
    private boolean isParent;

    private List<RegionDTO> children;

    public boolean getIsParent() {
        return isParent;
    }

    public void setIsParent(boolean isParent) {
        this.isParent = isParent;
    }
}
