package cn.gtmap.gtc.utilclient.common.client.rest;

import cn.gtmap.gtc.utilclient.common.dto.SignDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/9/5
 * @description
 */

@FeignClient(name = "util-center")
@RequestMapping("/util/rest/v1/signs")
public interface SignMangerClient {


    /**
     * @param processInsId 流程实例ID
     * @param signKey 表单标识
     * @param username 用户名
     * @return
     * @description 列表查询
     */
    @GetMapping("/list")
    List<SignDTO> list(@RequestParam("processInsId") String processInsId,
                              @RequestParam(value = "signKey",required = false) String signKey,
                              @RequestParam(value = "username",required = false) String username);



    /**
     * @param processInsId 流程实例ID
     * @param signKey 表单标识
     * @param opinion 签名意见
     * @return
     * @description 创建/更新签名意见
     */
    @PostMapping
    SignDTO save(@RequestParam("processInsId") String processInsId,
                        @RequestParam(value = "signKey") String signKey,
                        @RequestParam(value = "opinion", required = false) String opinion);


    /**
     * @param id 主键
     * @return
     * @description 删除用户签名
     */
    @DeleteMapping
    void delete(@RequestParam("id") String id);

    /**
     * @param processInsId 流程实例ID
     * @param signKey 表单标识
     * @return
     * @description 删除多个用户签名
     */
    @DeleteMapping("/multiple")
    void delete( @RequestParam("processInsId") String processInsId,
                        @RequestParam(value = "signKey", required = false) String signKey);
}