package cn.gtmap.gtc.utilclient.common.client.rest;

import cn.gtmap.gtc.utilclient.common.dto.DictionaryDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("${app.services.util-center:util-center}")
@RequestMapping("/util/rest/v1/dictionary")
public interface DictionaryClient {

    @PostMapping
    DictionaryDTO save(@RequestBody DictionaryDTO dto);

    @PutMapping
    DictionaryDTO update(@RequestBody  DictionaryDTO dto);

    @PutMapping("/updateBatch")
    List<DictionaryDTO> updateBatch(@RequestBody  List<DictionaryDTO> dtos);

    @DeleteMapping
    void delete(@RequestParam(value = "id", required = false) String id,
                @RequestParam(value = "code",required = false) String code);

    @GetMapping("/roots")
    List<DictionaryDTO> findRoots(@RequestParam(value = "clientId",required = false) String clientId,
                                  @RequestParam(value = "regionCode",required = false) String regionCode);

    @GetMapping("/rootsWithExts")
    List<DictionaryDTO> findRootsWithExts(@RequestParam(value = "clientId",required = false) String clientId,
                                          @RequestParam(value = "regionCode",required = false) String regionCode,
                                          @RequestParam(value = "ext1",required = false) String ext1,
                                          @RequestParam(value = "ext2",required = false) String ext2);

    @PostMapping("/get-node")
    public List<DictionaryDTO> findNodes(@RequestParam(value = "clientId",required = false) String clientId,
                                         @RequestParam(value = "regionCode",required = false) String regionCode,
                                         @RequestParam(value = "name", required = false) String name,
                                         @RequestParam(value = "ext1", required = false) String ext1,
                                         @RequestParam(value = "ext2", required = false) String ext2,
                                         @RequestParam(value = "like", required = false, defaultValue = "false") boolean like);

    @PostMapping("/get-children")
    List<DictionaryDTO> findChildren(@RequestParam(value = "clientId",required = false) String clientId,
                                     @RequestParam(value = "regionCode",required = false) String regionCode,
                                     @RequestParam(value = "id", required = false) String id,
                                     @RequestParam(value = "code", required = false) String code,
                                     @RequestParam(value = "name", required = false) String name,
                                     @RequestParam(value = "ext1", required = false) String ext1,
                                     @RequestParam(value = "ext2", required = false) String ext2,
                                     @RequestParam(value = "like", required = false, defaultValue = "false") boolean like);

    @PostMapping("/get-all-children")
    List<DictionaryDTO> findChildrenRecursive(@RequestParam(value = "clientId", required = false) String clientId,
                                              @RequestParam(value = "regionCode", required = false) String regionCode,
                                              @RequestParam(value = "id", required = false) String id,
                                              @RequestParam(value = "code", required = false) String code,
                                              @RequestParam(value = "name", required = false) String name,
                                              @RequestParam(value = "ext1", required = false) String ext1,
                                              @RequestParam(value = "ext2", required = false) String ext2,
                                              @RequestParam(value = "like", required = false, defaultValue = "false") boolean like);

    @PostMapping("/list-tree")
    List<DictionaryDTO> listRootTree(@RequestParam(value = "clientId",required = false) String clientId,
                                     @RequestParam(value = "regionCode",required = false) String regionCode,
                                     @RequestParam(value = "ext1", required = false) String ext1,
                                     @RequestParam(value = "ext2", required = false) String ext2);

    @GetMapping("/list-clientId")
    List<String> listAllClientId();
}
