/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.AuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import cn.gtmap.gtc.sso.domain.dto.OperationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="account")
@RequestMapping(value={"/account/rest/v1/authorities"})
public interface AuthorityManagerClient {
    @PostMapping
    public AuthorityDto createAuthority(@RequestBody AuthorityDto var1);

    @PutMapping
    public AuthorityDto updateAuthority(@RequestBody AuthorityDto var1);

    @PatchMapping(value={"/{id}/operation"})
    public boolean addOperation(@PathVariable(name="id") String var1, @RequestBody List<String> var2);

    @DeleteMapping(value={"/{id}/operation"})
    public boolean removeOperationRef(@PathVariable(name="id") String var1, @RequestBody List<String> var2);

    @DeleteMapping(value={"/{id}"})
    public boolean deleteAuthority(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}"})
    public AuthorityDto findById(@PathVariable(name="id") String var1);

    @PostMapping(value={"/search"})
    public List<AuthorityDto> findAuthorities(@RequestBody AuthorityDto var1);

    @GetMapping(value={"/url"})
    public List<AuthorityDto> findUrlAuthorities(@RequestParam(name="username") String var1, @RequestParam(name="path") String var2, @RequestParam(name="method", required=false) String var3);

    @GetMapping(value={"module-code"})
    public List<AuthorityDto> findModuleAuthorities(@RequestParam(name="username") String var1, @RequestParam(name="moduleCode") String var2);

    @GetMapping(value={"/module-operations"})
    public List<OperationDto> findModuleAuthorityOperation(@RequestParam(name="username") String var1, @RequestParam(name="moduleCode") String var2);

    @GetMapping(value={"/client-modules"})
    public List<AuthorityDto> findModuleTypeAuthorities(@RequestParam(name="username") String var1, @RequestParam(name="clientId", required=false) String var2, @RequestParam(name="moduleType", required=false) String var3);

    @GetMapping(value={"/sub-module/authorities"})
    public List<AuthorityDto> findSubModuleAuthorities(@RequestParam(name="username") String var1, @RequestParam(name="moduleCode") String var2, @RequestParam(name="moduleType") String var3);

    @GetMapping(value={"/menu-codes"})
    public String findMenuModules(@RequestParam(name="username") String var1, @RequestParam(name="clientId", required=false) String var2);

    @GetMapping(value={"/client/user/modules"})
    public List<ModuleDto> findClientUserModules(@RequestParam(name="username") String var1, @RequestParam(name="clientId") String var2, @RequestParam(name="moduleType") String var3);

    @GetMapping(value={"/sub/user/modules"})
    public List<ModuleDto> findSubUserModules(@RequestParam(name="username") String var1, @RequestParam(name="moduleCode") String var2, @RequestParam(name="moduleType") String var3);

    @GetMapping(value={"/module/roles"})
    public List<RoleDto> hasAuthRoles(@RequestParam(name="username") String var1, @RequestParam(name="moduleCode") String var2);
}

