/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.BaseResultDto;
import cn.gtmap.gtc.sso.domain.dto.DataAccessDto;
import cn.gtmap.gtc.sso.domain.dto.OAuth2AccessTokenDto;
import cn.gtmap.gtc.sso.domain.dto.UrlAuthAccessDto;
import cn.gtmap.gtc.sso.domain.mem.SecurityMetaUrlSource;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="account")
@RequestMapping(value={"/account"})
public interface OauthManagerClient {
    @PostMapping(value={"/oauth/token"})
    public OAuth2AccessTokenDto getAccessToken(@RequestParam(name="grant_type") String var1, @RequestParam(name="client_id") String var2, @RequestParam(name="client_secret") String var3, @RequestParam(name="username", required=false) String var4, @RequestParam(name="password", required=false) String var5, @RequestParam(name="validitySeconds", required=false) String var6, @RequestParam(name="customToken", required=false) String var7);

    @GetMapping(value={"/auth/check/module-authority"})
    public boolean checkUsernameAuthority(@RequestParam(name="username") String var1, @RequestParam(name="authority") String var2, @RequestParam(name="clientId", required=false) String var3);

    @GetMapping(value={"/auth/check/url-authority"})
    public boolean checkUrlAuthority(@RequestParam(name="username") String var1, @RequestParam(name="authority") String var2, @RequestParam(name="path") String var3, @RequestParam(name="clientId") String var4, @RequestParam(name="method") String var5);

    @GetMapping(value={"/auth/module/authority-code"})
    public String findModuleAuthority(@RequestParam(name="username") String var1, @RequestParam(name="moduleCode") String var2, @RequestParam(name="clientId", required=false) String var3);

    @GetMapping(value={"/auth/url/authority-code"})
    public String findUrlAuthority(@RequestParam(name="username") String var1, @RequestParam(name="path") String var2, @RequestParam(name="clientId") String var3, @RequestParam(name="method", required=false) String var4);

    @GetMapping(value={"/auth/menu/url-authority"})
    public Map<String, String> findMenuUrlAuthority(@RequestParam(name="username") String var1, @RequestParam(name="path") String var2, @RequestParam(name="clientId") String var3, @RequestParam(name="method", required=false) String var4);

    @GetMapping(value={"/auth/menu/module-authority"})
    public Map<String, String> findMenuModuleAuthority(@RequestParam(name="username") String var1, @RequestParam(name="moduleCode") String var2, @RequestParam(name="clientId", required=false) String var3);

    @DeleteMapping(value={"/auth/session"})
    public void cleanSession(@RequestParam(name="username") String var1);

    @Deprecated
    @PostMapping(value={"/auth/url/access"})
    public BaseResultDto urlAccess(@RequestBody UrlAuthAccessDto var1);

    @GetMapping(value={"/auth/client/access/config"})
    public List<SecurityMetaUrlSource> listClientUrlAccessConfig(@RequestParam(name="clientId") String var1);

    @GetMapping(value={"/auth/data/authority"})
    public String userDataAuthority(@RequestParam(name="username", required=false) String var1, @RequestParam(name="clientIp", required=false) String var2, @RequestParam(name="dataType") String var3, @RequestParam(name="code") String var4);

    @GetMapping(value={"/auth/data/{id}/authority"})
    public DataAccessDto dataAuthorityById(@PathVariable(name="id") String var1, @RequestParam(name="code", required=false) String var2, @RequestParam(name="clientIp", required=false) String var3);
}

