package cn.gtmap.gtc.sso.domain.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/11/8
 * @description
 */

@Getter
@Setter
public class TimeAccessStatsDto implements Serializable {

    /*
     *  时间
     *  1. yyyy-MM-dd
     * */
    private String time;

    /*
     *  总访问量
     * */
    private int total;

    /*
     *  每个应用的访问量
     *  key: 应用名称，  value: 访问量
     * */
    private Map<String, Integer> details;


    @Override
    public String toString() {
        return "TimeAccessStatsDto{" +
                "time='" + time + '\'' +
                ", total=" + total +
                ", details=" + details +
                '}';
    }
}
