package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ModuleTypeDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zenglihuan
 * @create 2018/8/30 11:03
 * @discription 模块类型 feign
 **/
@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/module-types")
public interface ModuleTypeManagerClient {

    /**
     * @param  moduleTypeDto 模块类型信息
     * @return
     * @description 添加类型
     */
    @PostMapping
    ModuleTypeDto create(@RequestBody ModuleTypeDto moduleTypeDto);

    /**
     * @param  moduleTypeDto 模块类型信息
     * @return
     * @description 更新类型
     */
    @PutMapping
    ModuleTypeDto update(@RequestBody ModuleTypeDto moduleTypeDto);

    /**
     * @param  id 模块类型id
     * @return
     * @description 删除类型
     */
    @DeleteMapping("/{id}")
    boolean delete(@PathVariable(name = "id") String id);

    /**
     * @param  id 模块类型id
     * @return
     * @description 根据ID查询类型
     */
    @GetMapping("/{id}")
    ModuleTypeDto findById(@PathVariable(name = "id") String id);

    /**
     * @param  id 模块类型id
     * @param  code 模块类型编码
     * @return
     * @description 校验Code的唯一性
     */
    @GetMapping("/{code}/code-only")
    boolean validOnlyCode(@RequestParam(name = "id", required = false) String id,
                                   @PathVariable(name = "code") String code);

    /**
     * @param
     * @return
     * @description 查询所有类型
     */
    @GetMapping
    List<ModuleTypeDto> findAll();

}
