package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.DataAuthorityDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/12/28
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/data-authorities")
public interface DataAuthorityClient {

    /**
     * @param  dataAuthorityDto 数据权限信息
     * @return
     * @description 添加/更新数据权限信息
     */
    @PostMapping
    DataAuthorityDto saveDataAuthority(@RequestBody DataAuthorityDto dataAuthorityDto);

    /**
     * @param  authorityDtos 数据权限信息
     * @return
     * @description 批量添加数据权限信息
     */
    @PostMapping("/batch")
    boolean saveDataAuthorities(@RequestBody List<DataAuthorityDto> authorityDtos);

    /**
     * @param  id
     * @return
     * @description 删除数据权限
     */
    @DeleteMapping
    boolean deleteAuthority(@RequestParam(name = "id") String id);


    /**
     * @param  username 用户名称
     * @param  moduleCode 模型编码
     * @param  code 资源编码或资源主键
     * @return
     * @description 查询用户配置的数据权限
     */
    @GetMapping("/user-authority")
    DataAuthorityDto findConfigUserAuthority(@RequestParam(name = "username") String username, @RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "code") String code);

    /**
     * @param  roleId 角色主键
     * @param  moduleCode 模型编码
     * @param  code 资源编码或资源主键
     * @return
     * @description 查询角色配置的数据权限
     */
    @GetMapping("/role-authority")
    DataAuthorityDto findConfigRoleAuthority(@RequestParam(name = "roleId") String roleId,@RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "code") String code);

    /**
     * @param  orgId 组织主键
     * @param  moduleCode 模型编码
     * @param  code 资源编码或资源主键
     * @return
     * @description 查询组织配置的数据权限
     */
    @GetMapping("/org-authority")
    DataAuthorityDto findConfigOrgAuthority(@RequestParam(name = "orgId") String orgId,@RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "code") String code);

    /**
     * @param  username 数据权限信息
     * @param  moduleCode 模型编码
     * @param  code 资源编码或资源主键
     * @return
     * @description 数据鉴权服务，返回当前人员,角色，组织拼接的鉴权码
     */
    @GetMapping("/authority")
    String userDataAuthority(@RequestParam(name = "username") String username,@RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "code") String code);


    /**
     * @param  username 用户名
     * @param  alias 姓名
     * @return
     * @description 分页查询已有用户的数据权限
     */
    @GetMapping("/user-authorities")
    Page<DataAuthorityDto> findUserPage(Pageable pageable, @RequestParam(name = "username", required = false) String username,
                                               @RequestParam(name = "alias", required = false) String alias);

    /**
     * @param  name 角色编码
     * @param  alias 角色名称
     * @return
     * @description 分页查询已有角色的数据权限
     */
    @GetMapping("/role-authorities")
    Page<DataAuthorityDto> findRolePage(Pageable pageable, @RequestParam(name = "name", required = false) String name,
                                               @RequestParam(name = "alias", required = false) String alias);

    /**
     * @param  code 组织编码
     * @param  name 组织名称
     * @return
     * @description 分页查询已有组织的数据权限
     */
    @GetMapping("/org-authorities")
    Page<DataAuthorityDto> findOrgPage(Pageable pageable, @RequestParam(name = "code", required = false) String code,
                                              @RequestParam(name = "name", required = false) String name);
}
