package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0, 2018/6/11
 * @description
 */

@Getter
@Setter
public class ClientDto implements Serializable {

    /*
     *  主键
     * */
    private String id;

    /*
     *  名称
     * */
    private String name;

    /*
     *  应用id
     * */
    private String clientId;

    /*
     *  应用密钥
     * */
    private String clientSecret;

    /*
     *  1：禁用 0：正常
     * */
    private int enabled;

    /*
     *  刷新token时长（s）
     * */
    private Integer refreshTokenValiditySeconds;

    /*
     *  token有效时长
     * */
    private Integer accessTokenValiditySeconds;

    /*
     *  授权类型
     * */
    private String authorizedGrantTypes;

    /*
     *  登陆重定向
     * */
    private String registeredRedirectUris;

    /*
     *  是否自动鉴权 "true", "false"
     * */
    private String autoApproveScopes;

    /*
     *  用有的资源范围列表
     * */
    private List<ScopeDto> scopes;

    /*
     *  创建时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    /*
     *  更新时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;

    @Override
    public String toString() {
        return "ClientDto{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", clientId='" + clientId + '\'' +
                ", clientSecret='" + clientSecret + '\'' +
                ", enabled=" + enabled +
                ", refreshTokenValiditySeconds=" + refreshTokenValiditySeconds +
                ", accessTokenValiditySeconds=" + accessTokenValiditySeconds +
                ", authorizedGrantTypes='" + authorizedGrantTypes + '\'' +
                ", registeredRedirectUris='" + registeredRedirectUris + '\'' +
                ", autoApproveScopes='" + autoApproveScopes + '\'' +
                ", scopes=" + scopes +
                ", createAt=" + createAt +
                ", updateAt=" + updateAt +
                '}';
    }
}
