package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ScopeDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/8/3
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/scopes")
public interface ScopeManagerClient {

    /**
     * @param scopeDto 资源范围信息
     * @return
     * @description 添加Scope
     */
    @PostMapping
    ScopeDto createNewScope(@RequestBody ScopeDto scopeDto);

    /**
     * @param name 资源范围编码
     * @param alias 资源范围名称/描述
     * @return
     * @description 分页显示权限范围列表，模糊收索
     */
    @GetMapping
    Page<ScopeDto> listScopes(Pageable pageable, @RequestParam(name = "name") String name, @RequestParam(name = "alias") String alias);

    /**
     * @param  id 资源范围id
     * @return
     * @description 删除权限范围
     */
    @DeleteMapping("/{id}")
    Boolean deleteScope(@PathVariable(name = "id") String id);
}
