package cn.gtmap.gtc.sso.domain.mem;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/8/27
 * @description
 */

@Data
public class UrlAccessCache implements Serializable {

    private static final long serialVersionUID = 1L;

    private boolean init = false;

    private TreeSet<String> unlimits = new TreeSet<>();

    private TreeMap<String, List<String>> limits = new TreeMap<>();

    public void addUnlimits(Collection<String> url){
        if (!CollectionUtils.isEmpty(url)) {
            unlimits.addAll(url);
        }
    }

    public void addLimit(String url, String id){
        if (limits.get(url) != null) {
            limits.get(url).add(id);
        } else {
            List<String> list = new ArrayList<>();
            list.add(id);
            limits.put(url, list);
        }
    }

}
