package cn.gtmap.gtc.sso.domain.enums;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/2/18
 * @description
 */
public enum ModuleTypeEnum {
    /*
    * 子系统
    * */
    SUBSYSTEM ("subsystem"),

    /*
     * 业务分类
     * */
    CLASSIFICATION ("classification"),

    /*
     * 菜单
     * */
    MENU ("menu"),

    /*
     * 表单
     * */
    FORM ("form"),

    /*
     * 页面元素
     * */
    ELEMENT ("element"),

    /*
     * 服务api
     * */
    API ("api"),

    /*
     * 数据资源
     * */
    DATA("data");

    private String type;

    ModuleTypeEnum(String type){
        this.type = type;
    }

    public String value(){
        return  this.type;
    }

    public static ModuleTypeEnum enumValue(String type){
        if (null == type){
            return null;
        }
        if ("subsystem".equals(type)) {
            return SUBSYSTEM;
        } else if ("classification".equals(type)) {
            return CLASSIFICATION;
        } else if ("menu".equals(type)) {
            return MENU;
        } else if ("form".equals(type)) {
            return FORM;
        } else if ("element".equals(type)) {
            return ELEMENT;
        } else if ("api".equals(type)) {
            return API;
        } else if("data".equals(type)){
            return DATA;
        }
        return null;
    }
}
