package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/8/27
 * @description
 */

@Data
public class UrlAccessConfigDto implements Serializable {

    private String id;

    // 名称
    private String name;

    //应用Id
    private String clientId;

    //限制类型
    private String accessType;

    // 限制类型 名称
    private String acccessTypeName;

    // 访问限制标识， 用户ID列表， 角色ID列表， 组织ID列表， 资源范围编码, 模块编码，
    private String accessIds;

    //访问限制标识 名称
    private String accessNames;

    //操作码列表
    private String optCodes;

    //操作码名称
    private String optCodeNames;

    // 操作码关系  AND: 并  OR:或
    private String optRef;

    //操作码关系名称
    private String refName;

    //限制路径
    private String accessUrl;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

}
