package cn.gtmap.gtc.sso.domain.dto;

import java.io.Serializable;
import java.util.List;

/**
 * @author zenglihuan
 * @create 2018/6/29 17:29
 * @discription 行政区化数据传输层
 **/
public class RegionDto implements Serializable {

    /*
     *  主键
     * */
    private String id;

    /*
     *  编码
     * */
    private String code;

    /*
     *  名称
     * */
    private String name;

    /*
     *  等级 1：省 2：市 3：区/县  4：乡镇
     * */
    private int level;

    /*
     *  是否禁用 1：是 0：否
     * */
    private int enabled;

    /*
     *  上一级主键
     * */
    private String parentId;

    /*
     *  上一级编码
     * */
    private String parentCode;

    /*
     *  上一级名称
     * */
    private String parentName;

    /*
     *  空间信息
     * */
    private String spatialInfo;

    /*
     *  是否拥有子集， 根据ztree 定义
     * */
    private boolean isParent;

    private List<OrganizationDto> orgs;

    public List<OrganizationDto> getOrgs() {
        return orgs;
    }

    public void setOrgs(List<OrganizationDto> orgs) {
        this.orgs = orgs;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getEnabled() {
        return enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean getIsParent() {
        return isParent;
    }

    public void setIsParent(boolean isParent) {
        this.isParent = isParent;
    }

    public String getSpatialInfo() {
        return spatialInfo;
    }

    public void setSpatialInfo(String spatialInfo) {
        this.spatialInfo = spatialInfo;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }
}
