package cn.gtmap.gtc.sso.domain.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/8/1
 * @description 用于zipkin 日志存储
 */
@Setter
@Getter
public class EsAnnotation implements Serializable {
    private Long timestamp;
    private String value;
    private EsEndpoint endpoint;

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("EsAnnotation{");
        builder.append("timestamp=").append(timestamp).append(", value='").append(value);
        if(null != endpoint){
            builder.append(", endpoint=").append(endpoint.toString());
        }
        builder.append("}");

        return builder.toString();
    }

}
