package cn.gtmap.gtc.sso.domain.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author zenglihuan
 * @create 2018/7/5 16:02
 * @discription 权限管理 DTO
 **/
@Setter
@Getter
public class AuthorityDto implements Serializable {

    /*
     *  主键
     * */
    private String id;

    /*
     *  用户主键
     * */
    private String userId;

    /*
     *  用户名
     * */
    private String userName;

    /*
     *  姓名
     * */
    private String userAlias;

    /*
     *  角色主键
     * */
    private String roleId;

    /*
     *  角色编码
     * */
    private String roleName;

    /*
     *  角色中文名称
     * */
    private String roleAlias;

    /*
     *  模块主键
     * */
    private String moduleId;

    /*
     *  模块编码
     * */
    private String moduleCode;

    /*
     *  模块名称
     * */
    private String moduleName;

    /*
     *  模块url
     * */
    private String moduleUrl;

    /*
     *  模块的应用ID
     * */
    private String moduleClientId;

    /*
     *  模块类型编码
     * */
    private String moduleTypeCode;

    /*
     *  模块类型名称
     * */
    private String moduleTypeName;

    /*
     *  权限码
     * */
    private String authority;

    /*
     *  当前模块的操作权限
     * */
    private List<OperationDto> operations;

    /*
     *  可操作页面元素id列表
     * */
    @Deprecated
    private Set<String> elementCodes;

    /*
     *  页面元素编码： 操作编码串
     * */
    private Map<String,String> elementsAuthorities;
}
