package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">Administrator</a>
 * @version 1.0, 2018/6/12
 * @description
 */

@Getter
@Setter
public class AuditLogDto implements Serializable {

    /*
     *  span id
     * */
    private String id;

    /*
     *  span name
     * */
    private String name;

    /*
     *  调用链路唯一标识
     * */
    private String traceId;

    /*
     *  上一级span id
     * */
    private String parentId;

    /*
     *  发生时间 匹配zipKin 数据格式
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date timestamp_millis;

    /*
     *  持续时间(ms)
     * */
    private Integer duration;

    /*
     *  身份信息
     * */
    private String principal;

    /*
     *  事件类型
     * */
    private String event;

    /*
     *  zipkin 存储格式中的注解信息
     * */
    private List<EsAnnotation> annotations;

    /*
     *  zipkin 存储格式中的数据信息
     * */
    private List<DataValue> binaryAnnotations;

    @Override
    public String toString() {
        return "AuditLogDto{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", traceId='" + traceId + '\'' +
                ", parentId='" + parentId + '\'' +
                ", timestamp_millis=" + timestamp_millis +
                ", duration='" + duration + '\'' +
                ", principal='" + principal + '\'' +
                ", event='" + event + '\'' +
                ", annotations=" + annotations +
                ", binaryAnnotations=" + binaryAnnotations +
                '}';
    }
}
