package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.DataResourceDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/12/28
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/datas")
public interface DataResourceClient {

    /**
     * @param  moduleCode 模块编码
     * @param  moduleName 模块名称
     * @param  code 资源编码
     * @param  desc 描述
     * @return
     * @description 添加/更新数据资源, 更新时不更新code
     */
    @PostMapping
    DataResourceDto saveDataResource(@RequestParam(name = "moduleCode") String moduleCode,
                                              @RequestParam(name = "moduleName", required = false) String moduleName,
                                              @RequestParam(name = "code") String code,
                                              @RequestParam(name = "desc", required = false) String desc);

    @GetMapping("/code")
    DataResourceDto getDataResource(@RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "code") String code);


    /**
     * @param   id 主键
     * @return
     * @description 通过Id获取数据资源
     */
    @GetMapping("/{id}")
    DataResourceDto getDataResource(@PathVariable(name = "id") String id);

    /**
     * @param   id 主键
     * @return
     * @description 删除数据资源
     */
    @DeleteMapping
    boolean deleteDataResource(@RequestParam(name = "id") String id);

    /**
     * @param  moduleCode 模块编码
     * @param  code 资源编码
     * @return
     * @description 检查数据是否存在
     */
    @GetMapping("/existed")
    boolean checkExisted(@RequestParam(name = "moduleCode") String moduleCode, @RequestParam(name = "code") String code);

    /**
     * @param  moduleCode 模块编码
     * @param  code 资源编码
     * @return
     * @description 分页查询数据
     */
    @GetMapping("/list")
    Page<DataResourceDto> findDatas(Pageable pageable, @RequestParam(name = "clientId", required = false) String clientId,
                                           @RequestParam(name = "moduleCode", required = false) String moduleCode,
                                           @RequestParam(name = "code",  required = false) String code);
}
