package cn.gtmap.gtc.clients;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/7/29
 * @description
 */

@FeignClient(name = "log-app")
@RequestMapping("/rest/v1/customs")
public interface CustomRecordClient {


    /**
     * @param index: es 索引
     * @param value: value配置值
     * @param keys: 匹配字段列表
     * @return
     * @description 多字段模糊匹配查询
     */
    @GetMapping("/page")
    Page<Map<String,Object>> multiWildcard(Pageable pageable, @RequestParam(name = "index") String index,
                                                  @RequestParam(name = "value") String value,
                                                  @RequestParam(name = "keys") String keys);

    /**
     * @param index: es 索引
     * @param id: 记录ID
     * @param data: 保存的数据
     * @return
     * @description 保存更新记录
     */
    @PostMapping
    void saveOrUpdate(@RequestParam(name = "index") String index,
                             @RequestParam(name = "id") String id,
                             @RequestBody Map<String, Object> data);

    /**
     * @param index: es 索引
     * @param id: 记录ID
     * @return
     * @description 删除记录
     */
    @DeleteMapping
    void delete(@RequestParam(name = "index") String index,
                       @RequestParam(name = "id") String id);


    /**
     * @param index: es 索引
     * @param id: 记录ID
     * @return
     * @description 通过ID查询
     */
    @GetMapping
    Map<String,Object> findById(@RequestParam(name = "index") String index,
                                       @RequestParam(name = "id") String id);
}
