package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.UserCollectionDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/8/3
 * @description
 */
@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/collections")
public interface CollectionManagerClient {

    /**
     * @param
     * @return
     * @description 保存/更新用户收藏关系
     */

    @PostMapping("/user/relation")
    UserCollectionDto saveUserCollection(@RequestParam(name = "username") String username, @RequestBody UserCollectionDto userCollectionDto);

    /**
     * @param username: 用户名
     * @param code: 收藏编码
     * @return
     * @description 删除用户收藏关系
     */

    @DeleteMapping("/user/relation")
    boolean deleteRelation(@RequestParam(name = "username") String username, @RequestParam(name = "code") String code);

    /**
     * @param code：收藏编码
     * @return
     * @description 删除收藏，同时删除收藏的所有用户关联
     */
    @DeleteMapping
    boolean deleteCollection(@RequestParam(name = "code") String code);

    /**
     * @param
     * @return
     * @description 保存/更新收藏信息
     */
    @PostMapping
    UserCollectionDto saveCollection(@RequestBody UserCollectionDto userCollectionDto);


    /**
     * @param username 用户名
     * @param type 收藏类型
     * @return
     * @description 根据收藏类型获取用户收藏列表
     */
    @GetMapping
    List<UserCollectionDto> listUserCollectionByType(@RequestParam(name = "username") String username, @RequestParam(name = "type") String type);


}
