/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.ProvinceCityCountyDto;
import cn.gtmap.gtc.sso.domain.dto.RegionDto;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="account")
@RequestMapping(value={"/account/rest/v1/regions"})
public interface RegionManagerClient {
    @PostMapping
    public RegionDto createRegion(@RequestBody RegionDto var1);

    @PostMapping(value={"/import"})
    public boolean importRegions(@RequestBody List<RegionDto> var1);

    @PutMapping
    public RegionDto updateRegion(@RequestBody RegionDto var1);

    @DeleteMapping(value={"/{id}"})
    public boolean deleteRegion(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/disable"})
    public boolean disableRegion(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/enable"})
    public boolean enableRegion(@PathVariable(name="id") String var1);

    @GetMapping(value={"/level"})
    public List<RegionDto> findRegionsByLevel(@RequestParam(name="level") int var1);

    @GetMapping(value={"/code"})
    public RegionDto findRegionByCode(@RequestParam(name="code") String var1);

    @GetMapping(value={"/name"})
    public RegionDto findRegionByName(@RequestParam(name="name") String var1);

    @GetMapping(value={"/{code}/code-only"})
    public boolean validOnlyCode(@RequestParam(name="id", required=false) String var1, @PathVariable(name="code") String var2);

    @GetMapping(value={"/{id}"})
    public RegionDto findRegionById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}/province-city-county"})
    public ProvinceCityCountyDto getProCityCounty(@PathVariable(name="id") String var1);

    @GetMapping(value={"/root"})
    public List<RegionDto> findRootRegions();

    @GetMapping(value={"/root/enabled"})
    public List<RegionDto> findRootRegionsEnabled();

    @GetMapping(value={"/{id}/junior"})
    public List<RegionDto> findJuniorRegions(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}/junior/enabled"})
    public List<RegionDto> findJuniorRegionsEnabled(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}/orgs"})
    public List<OrganizationDto> findOrgsByRegion(@PathVariable(name="id") String var1);
}

