/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="account")
@RequestMapping(value={"/account/rest/v1/orgs"})
public interface OrganizationManagerClient {
    @PostMapping
    public OrganizationDto createOrg(@RequestBody OrganizationDto var1);

    @PostMapping(value={"/import"})
    public boolean createOrgs(@RequestBody List<OrganizationDto> var1);

    @PutMapping
    public OrganizationDto updateOrg(@RequestBody OrganizationDto var1);

    @DeleteMapping(value={"/{id}"})
    public boolean deleteOrg(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}"})
    public OrganizationDto findOrgById(@PathVariable(name="id") String var1);

    @PostMapping(value={"/ids"})
    public List<OrganizationDto> findOrgByIds(@RequestBody List<String> var1);

    @GetMapping(value={"/{id}/users"})
    public Page<UserDto> findUsersByOrg(Pageable var1, @PathVariable(name="id") String var2);

    @GetMapping(value={"/{id}/root"})
    public OrganizationDto queryRootOrg(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}/junior"})
    @Deprecated
    public List<OrganizationDto> findJuniorOrgs(@PathVariable(name="id") String var1);

    @GetMapping(value={"/{id}/children"})
    public List<OrganizationDto> findChildren(@PathVariable(name="id") String var1, @RequestParam(name="enabled", required=false) Integer var2);

    @GetMapping(value={"/root"})
    public List<OrganizationDto> findRootOrgs();

    @PostMapping(value={"/{id}/parent"})
    public boolean relateParent(@PathVariable(name="id") String var1, @RequestParam(name="parentId") String var2);

    @PostMapping(value={"/{id}/disable"})
    public boolean disabled(@PathVariable(value="id") String var1);

    @PostMapping(value={"/{id}/enable"})
    public boolean enable(@PathVariable(value="id") String var1);

    @GetMapping(value={"/{code}/code-only"})
    public boolean validOnlyCode(@RequestParam(name="id", required=false) String var1, @PathVariable(name="code") String var2);

    @GetMapping(value={"/{id}/roles"})
    public List<RoleDto> listRoles(@PathVariable(name="id") String var1, @RequestParam(name="enabled", required=false) Integer var2);
}

