package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">Administrator</a>
 * @version 1.0, 2018/6/11
 * @description
 */

@Getter
@Setter
public class UserDto implements Serializable {

    /*
     *  主键
     * */
    private String id;

    /*
     *  用户名/登陆账户，数字/字母
     * */
    private String username;

    /*
     *  别称（中文姓名）
     * */
    private String alias;

    /*
    *  1 ：管理员
    * */
    private int admin;

    /*
     *  1 ：禁用 0：正常
     * */
    private int enabled;

    /*
     *  1 ：锁定 0：未锁
     * */
    private int locked;


    /*
     *  签名ID, 通过ID从文档中心下载签名图片
     * */
    private String signId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;

    /*
     *  失效时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date expired;

    /*
     *  密码
     * */
    private String password;

    /*
     *  手机号
     * */
    private String mobile;

    /*
     *  邮件
     * */
    private String email;

    /*
     *  办公电话
     * */
    private String tel;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date birthday;

    /*
     *  性别
     * */
    private String gender;

    /*
     *  职位
     * */
    private String title;

    /*
     *  个人简介
     * */
    private String resume;

    /*
     *  地址
     * */
    private String address;


    /*
     *  人员排序
     * */
    private String sequenceNumber;

    /*
     *  拥有角色列表
     * */
    private List<RoleDto> roleRecordList;

    /*
     *  拥有组织机构列表
     * */
    private List<OrganizationDto> orgRecordList;

    @Override
    public String toString() {
        return "UserDto{" +
                "id='" + id + '\'' +
                ", username='" + username + '\'' +
                ", alias='" + alias + '\'' +
                ", enabled=" + enabled +
                ", locked=" + locked +
                ", createAt=" + createAt +
                ", updateAt=" + updateAt +
                '}';
    }
}
