package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0, 2018/6/11
 * @description
 */
@Setter
@Getter
public class RoleDto implements Serializable {

    /*
     *  主键
     * */
    private String id;

    /*
     *  编码
     * */
    private String name;

    /*
     *  中文描述/名称
     * */
    private String alias;

    /*
     *  角色等级
     * */
    private int level;

    /*
     *  1 ：禁用 0：正常
     * */
    private int enabled;

    /*
     *  创建时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    /*
     *  更新时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;

    /*
     *  继承角色列表
     * */
    private List<RoleDto> parentRecords;

    /*
     *  互斥角色列表
     * */
    private List<RoleDto> excludeRecords;

    /*
     *  可配置角色列表
     * */
    private List<String> gradingRoleIds;

    /*
     *  角色的分级权限列表
     * */
    private List<GradingAuthorityDto> gradingAuthoritys;

    /*
     *  所属组织信息
     * */
    private List<OrganizationDto> orgRecords;

    @Override
    public String toString() {
        return "RoleDto{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", alias='" + alias + '\'' +
                ", enabled=" + enabled +
                ", createAt=" + createAt +
                ", updateAt=" + updateAt +
                '}';
    }
}
