package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0, 2018/7/7
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/orgs")
public interface OrganizationManagerClient {

    /**
     * @param orgRecord 组织信息
     * @return
     * @description 创建组织机构
     */
    @PostMapping
    OrganizationDto createOrg(@RequestBody OrganizationDto orgRecord);

    /**
     * @param orgRecords 组织信息
     * @return
     * @description 批量导入组织机构
     */
    @PostMapping("/import")
    boolean createOrgs(@RequestBody List<OrganizationDto> orgRecords);

    /**
     * @param orgRecord 组织信息
     * @return
     * @description 修改组织机构
     */
    @PutMapping
    OrganizationDto updateOrg(@RequestBody OrganizationDto orgRecord);

    /**
     * @param id 组织id
     * @return
     * @description 删除组织机构
     */
    @DeleteMapping("/{id}")
    boolean deleteOrg(@PathVariable(name = "id") String id);

    /**
     * @param id 组织id
     * @return
     * @description 根据ID查找组织机构
     */
    @GetMapping("/{id}")
    OrganizationDto findOrgById(@PathVariable(name = "id") String id);

    /**
     * @param ids 组织id列表
     * @return
     * @description 根据ID列表查找组织机构
     */
    @PostMapping("/ids")
    List<OrganizationDto> findOrgByIds(@RequestBody List<String> ids);

    /**
     * @param id 组织id
     * @return
     * @description 查找组织机构下的用户
     */
    @GetMapping("/{id}/users")
    Page<UserDto> findUsersByOrg(Pageable pageable, @PathVariable(name = "id") String id);

    /**
     * @param id 组织id
     * @return
     * @description 根据ID查找组织的根节点
     */
    @GetMapping("/{id}/root")
    OrganizationDto queryRootOrg(@PathVariable(name = "id") String id);

    /**
     * @param id 组织id
     * @return
     * @description 查找直接下级组织机构
     * @deprecated {@link OrganizationManagerClient#findChildren}
     */
    @GetMapping("/{id}/junior")
    @Deprecated
    List<OrganizationDto> findJuniorOrgs(@PathVariable(name = "id") String id);

    /**
     * @param id 组织id
     * @param enabled 0:禁用 1：正常 null: 全部
     * @return
     * @description 查找直接下级组织机构
     */
    @GetMapping("/{id}/children")
    List<OrganizationDto> findChildren(@PathVariable(name = "id") String id, @RequestParam(name = "enabled", required = false) Integer enabled);


    /**
     * @param
     * @return
     * @description 查找最顶级组织机构
     */
    @GetMapping("/root")
    List<OrganizationDto> findRootOrgs();

    /**
     * @param id 当前组织id
     * @param parentId 上级组织id
     * @return
     * @description 重设父级组织
     */
    @PostMapping("/{id}/parent")
    boolean relateParent(@PathVariable(name = "id") String id, @RequestParam(name = "parentId") String parentId);

    /**
     * @param id 当前组织id
     * @return
     * @description 禁用组织
     */
    @PostMapping("/{id}/disable")
    boolean disabled(@PathVariable("id") String id);

    /**
     * @param id 当前组织id
     * @return
     * @description 启用组织
     */
    @PostMapping("/{id}/enable")
    boolean enable(@PathVariable("id") String id);

    /**
     * @param id 当前组织id
     * @param code 组织编码
     * @return
     * @description 校验code的唯一性
     */
    @GetMapping("/{code}/code-only")
    boolean validOnlyCode(@RequestParam(name = "id", required = false) String id, @PathVariable(name = "code") String code);

    /**
     * @param id 当前组织id
     * @param enabled 1:正常 0：禁用
     * @return
     * @description 获取组织下角色
     */
    @GetMapping("/{id}/roles")
    List<RoleDto> listRoles(@PathVariable(name = "id") String id, @RequestParam(name = "enabled", required = false) Integer enabled);
}
