package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.OperationDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/7/26
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/operations")
public interface OperationManagerClient {
    /**
     * @param operation 操作信息
     * @return
     * @description 添加操作
     */
    @PostMapping
    OperationDto createOperation(@RequestBody OperationDto operation);

    /**
     * @param operation 操作信息
     * @return
     * @description 更新操作
     */
    @PutMapping
    OperationDto updateOperation(@RequestBody OperationDto operation);

    /**
     * @param id 操作id
     * @return
     * @description 删除操作
     */
    @DeleteMapping("/{id}")
    boolean deleteOperation(@PathVariable(name = "id") String id);

    /**
     * @param id 操作id
     * @return
     * @description 根据ID查询操作
     */
    @GetMapping("/{id}")
    OperationDto findById(@PathVariable(name = "id") String id);

    /**
     * @param id 操作id
     * @return
     * @description 验证操作码唯一性
     */
    @GetMapping("/{code}/code-only")
    boolean validOnlyCode(@RequestParam(name = "id", required = false) String id, @PathVariable(name = "code") String code);

    /**
     * @param
     * @return
     * @description 查询所有操作
     */
    @GetMapping
    List<OperationDto> findAll();

}
