package cn.gtmap.gtc.clients;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/8/3
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/auth")
public interface OauthManagerClient {

    /**
     * @param  username 用户名
     * @param  authority 权限码
     * @param  clientId  应用编码
     * @return
     * @description 根据用户名，权限码鉴权
     */
    @GetMapping("/check/module-authority")
    boolean checkUsernameAuthority(@RequestParam(name = "username") String username, @RequestParam(name = "authority") String authority, @RequestParam(name = "clientId") String clientId);

    /**
     * @param  username 用户名
     * @param  authority 权限码
     * @param  clientId  应用编码
     * @return
     * @description 根据用户名，url鉴权
     */
    @GetMapping("/check/url-authority")
    boolean checkUrlAuthority(@RequestParam(name = "username") String username, @RequestParam(name = "authority") String authority ,@RequestParam(name = "path") String path, @RequestParam(name = "clientId") String clientId, @RequestParam(name = "method") String method);

    /**
     * @param  username 用户名
     * @param  moduleCode 模块编码
     * @param  clientId  应用编码
     * @return
     * @description 根据模块编码，获取权限码
     */
    @GetMapping("/module/authority-code")
    String findModuleAuthority(@RequestParam(name = "username") String username,  @RequestParam(name = "moduleCode") String moduleCode , @RequestParam(name = "clientId") String clientId);

    /**
     * @param  username 用户名
     * @param  path 请求路径
     * @param  method GET POST DELETE....
     * @param  clientId  应用编码
     * @return
     * @description 根据用户名、url获取权限码
     */
    @GetMapping("/url/authority-code")
    String findUrlAuthority(@RequestParam(name = "username") String username, @RequestParam(name = "path") String path,
                                   @RequestParam(name = "clientId") String clientId, @RequestParam(name = "method", required = false) String method);

    /**
     * @param  username 用户名
     * @param  path 请求路径
     * @param  method GET POST DELETE....
     * @param  clientId  应用编码
     * @return root: 操作权限
     * @return elements: 元素权限
     * @description 根据用户名、url获取权限码
     */
    @GetMapping("/menu/url-authority")
    Map<String, String> findMenuUrlAuthority(@RequestParam(name = "username") String username, @RequestParam(name = "path") String path,
                                             @RequestParam(name = "clientId") String clientId, @RequestParam(name = "method", required = false) String method);

    /**
     * @param  username 用户名
     * @param  moduleCode 模块编码
     * @param  clientId  应用编码
     * @return root: 操作权限
     * @return elements: 元素权限
     * @description 根据用户名，模块编码获取鉴权码
     */
    @GetMapping("/menu/module-authority")
    Map<String, String> findMenuModuleAuthority(@RequestParam(name = "username") String username,  @RequestParam(name = "moduleCode") String moduleCode , @RequestParam(name = "clientId") String clientId);


}
