/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.AuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="account")
@RequestMapping(value={"/account/rest/v1/users"})
public interface UserManagerClient {
    @GetMapping(value={"/list"})
    public Page<UserDto> listUsers(@RequestParam(name="username") String var1, @RequestParam(name="alias") String var2, @RequestParam(name="enabled") Integer var3, Pageable var4);

    @GetMapping(value={"/grading-users"})
    public Page<UserDto> listGradeUsers(Pageable var1, @RequestParam(name="inquirer") String var2, @RequestParam(name="username", required=false) String var3, @RequestParam(name="alias", required=false) String var4, @RequestParam(name="enabled", required=false) Integer var5);

    @PostMapping
    public UserDto createNewUser(@RequestBody UserDto var1);

    @PutMapping(value={"/{id}"})
    public UserDto updateUser(@PathVariable(value="id") String var1, @RequestBody UserDto var2);

    @GetMapping(value={"/{id}"})
    public UserDto getUserDetail(@PathVariable(value="id") String var1);

    @GetMapping(value={"/username/{username}"})
    public UserDto getUserByUsername(@PathVariable(value="username") String var1);

    @PostMapping(value={"/{id}/enabled"})
    public Boolean enabledUser(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/sign"})
    public Boolean updateUserSign(@PathVariable(name="id") String var1, @RequestParam(name="signId") String var2);

    @PostMapping(value={"/{id}/disabled"})
    public Boolean disabledUser(@PathVariable(name="id") String var1);

    @DeleteMapping(value={"/{id}"})
    public Boolean deleteUser(@PathVariable(value="id") String var1);

    @PostMapping(value={"/{id}/roles"})
    public Boolean updateUserRoles(@PathVariable(value="id") String var1, @RequestBody List<String> var2);

    @PostMapping(value={"/{id}/orgs"})
    public Boolean updateUserOrgs(@PathVariable(value="id") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/{id}/all-roles"})
    public List<RoleDto> findAllRoles(@PathVariable(value="id") String var1);

    @GetMapping(value={"/{id}/roles"})
    public List<RoleDto> findRoles(@PathVariable(value="id") String var1);

    @GetMapping(value={"/{id}/orgs"})
    public List<OrganizationDto> findOrgs(@PathVariable(name="id") String var1);

    @GetMapping(value={"/root-orgs"})
    public List<OrganizationDto> findUserRootOrgs(@RequestParam(name="username") String var1);

    @PostMapping(value={"/check-password"})
    public Boolean checkUserPassword(@RequestParam(name="password") String var1, @RequestParam(name="id") String var2);

    @GetMapping(value={"/existed"})
    public Boolean checkUserExist(@RequestParam(name="username") String var1);

    @GetMapping(value={"/{id}/module-authority"})
    public AuthorityDto findUserModuleAuthority(@PathVariable(name="id") String var1, @RequestParam(name="moduleId") String var2);

    @GetMapping(value={"/{id}/authority"})
    public List<AuthorityDto> findAuthoritiesByUserid(@PathVariable(name="id") String var1);

    @GetMapping(value={"/username/authority"})
    public List<AuthorityDto> findAuthoritiesByUsername(@RequestParam(name="username") String var1);

    @PostMapping(value={"{id}/lock"})
    public Boolean lockUser(@PathVariable(name="id") String var1);

    @PostMapping(value={"{id}/unlock"})
    public Boolean unlockUser(@PathVariable(name="id") String var1);
}

