/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.AuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.GradingAuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="account")
@RequestMapping(value={"/account/rest/v1/roles"})
public interface RoleManagerClient {
    @PostMapping
    public RoleDto createRole(@RequestBody RoleDto var1);

    @GetMapping(value={"/{id}"})
    public RoleDto getRoleDetail(@PathVariable(value="id") String var1);

    @GetMapping(value={"/existed"})
    public Boolean checkRoleExist(@RequestParam(name="name") String var1);

    @PostMapping(value={"/{id}/enabled"})
    public Boolean enabledRole(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/disabled"})
    public Boolean disabledRole(@PathVariable(name="id") String var1);

    @PutMapping(value={"/{id}"})
    public RoleDto updateRoleDetail(@PathVariable(value="id") String var1, @RequestBody RoleDto var2);

    @GetMapping(value={"/name/{name}"})
    public RoleDto queryRoleByRoleName(@PathVariable(value="name") String var1);

    @GetMapping(value={"/page"})
    public Page<RoleDto> listRoleRecords(Pageable var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="alias", required=false) String var3, @RequestParam(name="enabled", required=false) Integer var4);

    @GetMapping(value={"/grading-roles"})
    public Page<RoleDto> listGradeRoleRecords(Pageable var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="alias", required=false) String var3, @RequestParam(name="enabled", required=false) Integer var4, @RequestParam(name="inquirer", required=false) String var5);

    @GetMapping(value={"/{id}/all-enabled-users"})
    public Page<UserDto> listAllUsersByRoleId(Pageable var1, @PathVariable(value="id") String var2);

    @GetMapping(value={"/name/{name}/all-enabled-users"})
    public Page<UserDto> listEnableUsersByName(Pageable var1, @PathVariable(value="name") String var2);

    @GetMapping
    public List<RoleDto> getAllRoleList();

    @GetMapping(value={"/enabled"})
    public List<RoleDto> getEnabledRoleList();

    @DeleteMapping(value={"/{id}"})
    public Boolean deleteRole(@PathVariable(value="id") String var1);

    @PostMapping(value={"/{id}/inheriting-roles"})
    public Boolean updateInheritRoles(@PathVariable(value="id") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/{id}/inheriting-roles"})
    public List<RoleDto> listInheritRoles(@PathVariable(value="id") String var1);

    @PostMapping(value={"/{id}/excluded-roles"})
    public Boolean updateExcludeRoles(@PathVariable(value="id") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/{id}/excluded-roles"})
    public List<RoleDto> listExcludeRoles(@PathVariable(value="id") String var1);

    @PostMapping(value={"/excluded-roles"})
    public List<RoleDto> listExcludeRolesByIds(@RequestBody List<String> var1);

    @PostMapping(value={"/enabled/excluded-roles"})
    public List<RoleDto> enabledExcludeRolesByIds(@RequestBody List<String> var1);

    @GetMapping(value={"/{id}/all-excluded-roles"})
    public List<RoleDto> listAllExcludeRoles(@PathVariable(value="id") String var1);

    @PutMapping(value={"/{id}/grading-authority"})
    public boolean saveGradingAuthority(@PathVariable(value="id") String var1, @RequestBody RoleDto var2);

    @GetMapping(value={"/{id}/grading-roles"})
    public List<RoleDto> findGradingRoles(@PathVariable(value="id") String var1);

    @GetMapping(value={"/{id}/grading-authority"})
    public List<GradingAuthorityDto> findGradingAuthority(@PathVariable(value="id") String var1);

    @GetMapping(value={"/authorities"})
    public List<AuthorityDto> findRoleAuthorities(@RequestBody List<String> var1);

    @GetMapping(value={"/modules"})
    public List<ModuleDto> findAuthorityModules(@RequestParam(name="roleId") String var1);

    @GetMapping(value={"/user/grading-modules"})
    public List<ModuleDto> findLoginUserGradingModules(@RequestParam(name="username") String var1, @RequestParam(name="pid", required=false) String var2, @RequestParam(name="gradedRoleId", required=false) String var3, @RequestParam(name="clientId", required=false) String var4);

    @GetMapping(value={"/{id}/grading-modules"})
    public List<ModuleDto> findGradingModules(@PathVariable(value="id") String var1);

    @GetMapping(value={"/user/grading-roles"})
    public List<RoleDto> findGradingRolesByLoginUser(@RequestParam(name="username") String var1);
}

